/*-------------------------
EDITED FOR Kenoby's Star Citizen Board
VERSION Keno-testb-v3
BASED ON 6-Encoders Radio Box v1
https://karons.home.blog/ 

/*
micro.build.vid=0x1535
micro.build.pid=0x5678
micro.build.usb_product="Kenoboard"
*/

#include <Keypad.h>
#include <Joystick.h>

#define ENABLE_PULLUPS
#define NUMROTARIES 0
#define NUMBUTTONS 64
#define NUMROWS 8
#define NUMCOLS 8


byte buttons[NUMROWS][NUMCOLS] = {
  {0,1,2,3,4,5,6,7},
  {8,9,10,11,12,13,14,15},
  {16,17,18,19,20,21,22,23},
  {24,25,26,27,28,29,30,31},
  {32,33,34,35,36,37,38,39},
  {40,41,42,43,44,45,46,47},
  {48,49,50,51,52,53,54,55},
  {56,57,58,59,60,61,62,63},
};

struct rotariesdef {
  byte pin1;
  byte pin2;
  int ccwchar;
  int cwchar;
  volatile unsigned char state;
};

rotariesdef rotaries[NUMROTARIES] {
  /*{0,1,9,10,0},
  {2,3,11,12,0},
  {4,5,13,14,0},
  {6,7,15,16,0},
  {8,9,17,18,0},
  {10,16,19,20,0},*/
};

#define DIR_CCW 0x10
#define DIR_CW 0x20
#define R_START 0x0

#ifdef HALF_STEP
#define R_CCW_BEGIN 0x1
#define R_CW_BEGIN 0x2
#define R_START_M 0x3
#define R_CW_BEGIN_M 0x4
#define R_CCW_BEGIN_M 0x5
const unsigned char ttable[6][4] = {
  // R_START (00)
  {R_START_M,            R_CW_BEGIN,     R_CCW_BEGIN,  R_START},
  // R_CCW_BEGIN
  {R_START_M | DIR_CCW, R_START,        R_CCW_BEGIN,  R_START},
  // R_CW_BEGIN
  {R_START_M | DIR_CW,  R_CW_BEGIN,     R_START,      R_START},
  // R_START_M (11)
  {R_START_M,            R_CCW_BEGIN_M,  R_CW_BEGIN_M, R_START},
  // R_CW_BEGIN_M
  {R_START_M,            R_START_M,      R_CW_BEGIN_M, R_START | DIR_CW},
  // R_CCW_BEGIN_M
  {R_START_M,            R_CCW_BEGIN_M,  R_START_M,    R_START | DIR_CCW},
};
#else
#define R_CW_FINAL 0x1
#define R_CW_BEGIN 0x2
#define R_CW_NEXT 0x3
#define R_CCW_BEGIN 0x4
#define R_CCW_FINAL 0x5
#define R_CCW_NEXT 0x6

const unsigned char ttable[7][4] = {
  // R_START
  {R_START,    R_CW_BEGIN,  R_CCW_BEGIN, R_START},
  // R_CW_FINAL
  {R_CW_NEXT,  R_START,     R_CW_FINAL,  R_START | DIR_CW},
  // R_CW_BEGIN
  {R_CW_NEXT,  R_CW_BEGIN,  R_START,     R_START},
  // R_CW_NEXT
  {R_CW_NEXT,  R_CW_BEGIN,  R_CW_FINAL,  R_START},
  // R_CCW_BEGIN
  {R_CCW_NEXT, R_START,     R_CCW_BEGIN, R_START},
  // R_CCW_FINAL
  {R_CCW_NEXT, R_CCW_FINAL, R_START,     R_START | DIR_CCW},
  // R_CCW_NEXT
  {R_CCW_NEXT, R_CCW_FINAL, R_CCW_BEGIN, R_START},
};
#endif

byte rowPins[NUMROWS] = {1,0,2,3,4,5,6,7}; 
byte colPins[NUMCOLS] = {8,9,10,16,14,15,A0,A1}; 

Keypad buttbx = Keypad( makeKeymap(buttons), rowPins, colPins, NUMROWS, NUMCOLS); 

Joystick_ Joystick(JOYSTICK_DEFAULT_REPORT_ID, 
  JOYSTICK_TYPE_JOYSTICK, 64, 0,
  false, false, false, false, false, false,
  false, false, false, false, false);

void setup() {
  for(int i=0;i<11;i++){
    pinMode(i, INPUT_PULLUP);
  }
  pinMode(16, INPUT_PULLUP);
  pinMode(14, INPUT_PULLUP);
  pinMode(15, INPUT_PULLUP);
  
  pinMode(A0, INPUT_PULLUP);
  pinMode(A1, INPUT_PULLUP);
  pinMode(A2, INPUT_PULLUP);
  pinMode(A3, INPUT_PULLUP);
  
  Joystick.begin();
  //rotary_init();
}

void loop() { 

  //CheckAllEncoders();

  CheckAllButtons();

  //printout();
}

void CheckAllButtons(void) {
      if (buttbx.getKeys())
    {
       for (int i=0; i<LIST_MAX; i++)   
        {
           if ( buttbx.key[i].stateChanged )   
            {
            switch (buttbx.key[i].kstate) {  
                    case PRESSED:
                    case HOLD:
                              Joystick.setButton(buttbx.key[i].kchar, 0);
                              /* //HANDY DEBUG STUFF
                              Serial.print("SENT1 ");
                              Serial.println(int(buttbx.key[i].kchar)); */
                              break;
                    case RELEASED:
                    case IDLE:
                              Joystick.setButton(buttbx.key[i].kchar, 0);
                              /* //HANDY DEBUG STUFF
                              Serial.print("SENT0 ");
                              Serial.println(int(buttbx.key[i].kchar)); */
                              break;
            }
           }   
         }
     }
}


void rotary_init() {
  for (int i=0;i<NUMROTARIES;i++) {
    pinMode(rotaries[i].pin1, INPUT);
    pinMode(rotaries[i].pin2, INPUT);
    #ifdef ENABLE_PULLUPS
      digitalWrite(rotaries[i].pin1, HIGH);
      digitalWrite(rotaries[i].pin2, HIGH);
    #endif
  }
}


unsigned char rotary_process(int _i) {
   unsigned char pinstate = (digitalRead(rotaries[_i].pin2) << 1) | digitalRead(rotaries[_i].pin1);
  rotaries[_i].state = ttable[rotaries[_i].state & 0xf][pinstate];
  return (rotaries[_i].state & 0x30);
}

void CheckAllEncoders(void) {
  for (int i=0;i<NUMROTARIES;i++) {
    unsigned char result = rotary_process(i);
    if (result == DIR_CCW) {
      Joystick.setButton(rotaries[i].ccwchar, 1); delay(50); Joystick.setButton(rotaries[i].ccwchar, 0);
    };
    if (result == DIR_CW) {
      Joystick.setButton(rotaries[i].cwchar, 1); delay(50); Joystick.setButton(rotaries[i].cwchar, 0);
    };
  }
}


/*void printout(){
 //HANDY DEBUG STUFF
  Serial.print("A0: ");
  Serial.print(A0);
  Serial.print(" A1: ");
  Serial.print(A1);
  Serial.print(" A2: ");
  Serial.print(A2);
  Serial.print(" A3: ");
  Serial.println(A3);
  delay(200);*/
  /*for(int i=0;i<11;i++){
    Serial.print(" [");
    Serial.print(i);
    Serial.print("]: ");
    Serial.print(digitalRead(i));
    Serial.print(" ");
  }
  Serial.print(" [16]: ");
  Serial.print(digitalRead(16));
  Serial.print(" [14]: ");
  Serial.print(digitalRead(14));
  Serial.print(" [15]: ");
  Serial.print(digitalRead(15));

  
  Serial.print(" [A0]: ");
  Serial.print(analogRead(A0));
  Serial.print(" [A1]: ");
  Serial.print(analogRead(A1));
  Serial.print(" [A2]: ");
  Serial.print(analogRead(A2));
  Serial.print(" [A3]: ");
  Serial.print(analogRead(A3));
  Serial.println("");
  delay(300);
}*/
